<?php

//no direct access
defined('_JEXEC') or die;

/**
 * Joomla! System SeoNitro Dynamically Controlled Linking Plugin
 *
 * @package Joomla.Plugin
 * @subpackage System.dcljoomla
 */
class plgSystemDcljoomla extends JPlugin {

    public function onContentPrepare($context, &$article, &$params, $limitstart) {
        $app = JFactory::getApplication();
        if ($app->isSite()) {
            //Only run from the client-side, never the admin side        
            $article->text = $this->dcl_process($article->text);
        }
    }

    public function onAfterRender() {

        $app = JFactory::getApplication();
        if ($app->isSite()) {
            //Only run from the client-side, never the admin side
            $buffer = JResponse::getBody();
            $buffer = $this->sidebar_process($buffer);
            JResponse::setBody($buffer);
            return true;
        }
    }

    function dcl_process($buffer) {
        $buffer = $buffer ? $buffer : '...';
        if (count($buffer)) {
            $postID = JRequest::getVar('Itemid');
            $postURI = "/index.php?option=com_content&view=article&id=$postID";
            $homeUrl = rtrim(JURI::base(), '/');
            $domain = $this->getNitroPlainDomain($homeUrl);
            $pinger = $homeUrl . $postURI;

            // check if [dcl=??] codes are found in the content
            preg_match_all('/\[dcl\=(\d+)\]/is', $buffer, $matches);
            $foundIds = $matches[1];

            // initialize global wordpress database class
            // define the table name for our plugin
            $campaignStatsTable = '#__dcl_campaign_stats';
            $campaignResultsTable = '#__dcl_campaign_results';

            $db = JFactory::getDBO();
            // if any codes are found start the process
            if (count($foundIds)) {
                // get the unique campaign ids as multiple codes for single campaign can exist
                $cIds = array_unique($foundIds);


                // start looping through the found campaign ids
                foreach ($cIds as $cId) {
                    // get the total code found for the current campaign id
                    $totalCodeFound = 0;
                    foreach ($foundIds as $fId) {
                        if ($fId == $cId)
                            $totalCodeFound++;
                    }

                    $query = $db->getQuery(true);
                    $query->select('*');
                    $query->from($campaignStatsTable);
                    $query->where("domain = '$domain' AND pinger = '$pinger' AND campaign_id = $cId");
                    $db->setQuery((string) $query);
                    $pingerExists = $db->loadObject();

                    //print_r($pingerExists);
                    //exit;

                    $statObj = new stdClass();
                    $statObj->domain = $domain;
                    $statObj->pinger = $pinger;
                    $statObj->post_id = $postID;
                    $statObj->campaign_id = $cId;
                    $statObj->codefound = $totalCodeFound;

                    //print_r($statObj); exit;
                    // if the pinger already exist, update the row if codefound is changed
                    if ($pingerExists) {
                        $statObj->id = $pingerExists->id;
                        $prevCodeFound = $pingerExists->codefound;
                        if ($totalCodeFound != $prevCodeFound) {
                            $success = JFactory::getDbo()->updateObject($campaignStatsTable, $statObj, 'id');
                        }
                    } else {
                        // if pinger doesn't exist insert the new pinger
                        $success = JFactory::getDbo()->insertObject($campaignStatsTable, $statObj);
                    }

                    $query = $db->getQuery(true);
                    $query->delete($campaignStatsTable);
                    $query->where("codefound = 0");
                    $db->setQuery($query);
                    $db->query();

                    $pResult = array();
                    $query = $db->getQuery(true);
                    $query->select('*');
                    $query->from($campaignResultsTable);
                    $query->where("pinger = '$pinger' AND campaign_id = $cId");
                    $db->setQuery((string) $query);
                    $pingerResult = $db->loadObject();

                    if ($pingerResult) {
                        $pResult = unserialize($pingerResult->results);
                    }

                    if ($pResult) {
                        $anchorSetIndex = $this->nitroGetAnchorSetIndex();
                        $pResultVersion = $pResult[$anchorSetIndex];
                        $pattern = "/\[dcl\={$cId}\]/is";
                        $patterns = array_fill(0, $totalCodeFound, $pattern);
                        $buffer = preg_replace($patterns, $pResultVersion, $buffer, 1);
                    }
                }
                $pattern = "/\[dcl\=(\d+)\]/is";
                $buffer = preg_replace(array($pattern), array(''), $buffer, 1);
            }
        }
        return $buffer;
    }

    function sidebar_process($buffer) {
        $buffer = $buffer ? $buffer : '...';
        if (count($buffer)) {
            $campaignResultsTable = '#__dcl_campaign_results';
            $db = JFactory::getDBO();
            $query = $db->getQuery(true);
            $query->select('*');
            $query->from($campaignResultsTable);
            $query->where("campaign_id = -1");
            $db->setQuery((string) $query);
            $blogRollResults = $db->loadObject();

            if ($blogRollResults) {
                $results = unserialize($blogRollResults->results);
                $anchorSetIndex = $this->nitroGetAnchorSetIndex();
                if (isset($results['sidebar_html'])) {
                    $buffer = str_replace('[dcl_sidebar]', $results['sidebar_html'][$anchorSetIndex], $buffer);
                } else {
                    $buffer = str_replace('[dcl_sidebar]', '-', $buffer);
                }
                if (isset($results['footer_html'])) {
                    $anchorSetIndex = $this->nitroGetAnchorSetIndex();
                    $buffer = str_replace('[dcl_footer]', $results['footer_html'][$anchorSetIndex], $buffer);
                } else {
                    $buffer = str_replace('[dcl_footer]', '-', $buffer);
                }
            }
        }
        return $buffer;
    }

    function getNitroPlainDomain($url) {
        $url = str_replace('http://', '', strtolower($url));
        $url = str_replace('https://', '', $url);
        $plainDomain = str_replace('www.', '', $url);
        if (strpos($url, '/')) {
            $plainDomain = strstr($url, '/', true);
        }
        return $plainDomain;
    }

    function nitroGetAnchorSetIndex() {
        $UTCtime = new DateTime('now', new DateTimeZone('UTC'));
        $nowMinuntes = date('i', strtotime($UTCtime->format('F j, Y H:i:s')));
        return round($nowMinuntes / 5) % 4;
    }

}

?>